/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import io.trino.jdbc.$internal.client.ProtocolDetectionException;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class ProtocolHeaders {
    public static final ProtocolHeaders TRINO_HEADERS = new ProtocolHeaders("Trino");
    private final String name;
    private final String requestUser;
    private final String requestOriginalUser;
    private final String requestOriginalRole;
    private final String requestSource;
    private final String requestCatalog;
    private final String requestSchema;
    private final String requestPath;
    private final String requestTimeZone;
    private final String requestLanguage;
    private final String requestTraceToken;
    private final String requestSession;
    private final String requestRole;
    private final String requestPreparedStatement;
    private final String requestTransactionId;
    private final String requestClientInfo;
    private final String requestClientTags;
    private final String requestClientCapabilities;
    private final String requestResourceEstimate;
    private final String requestExtraCredential;
    private final String requestQueryDataEncoding;
    private final String responseSetCatalog;
    private final String responseSetSchema;
    private final String responseSetPath;
    private final String responseSetSession;
    private final String responseClearSession;
    private final String responseSetRole;
    private final String responseQueryDataEncoding;
    private final String responseAddedPrepare;
    private final String responseDeallocatedPrepare;
    private final String responseStartedTransactionId;
    private final String responseClearTransactionId;
    private final String responseSetAuthorizationUser;
    private final String responseResetAuthorizationUser;
    private final String responseOriginalRole;

    public static ProtocolHeaders createProtocolHeaders(String name) {
        if (TRINO_HEADERS.getProtocolName().equalsIgnoreCase(name)) {
            return TRINO_HEADERS;
        }
        return new ProtocolHeaders(name);
    }

    private ProtocolHeaders(String name) {
        Objects.requireNonNull(name, "name is null");
        Preconditions.checkArgument(!name.isEmpty(), "name is empty");
        this.name = name;
        this.requestUser = Headers.REQUEST_USER.withProtocolName(name);
        this.requestOriginalUser = Headers.REQUEST_ORIGINAL_USER.withProtocolName(name);
        this.requestOriginalRole = Headers.REQUEST_ORIGINAL_ROLES.withProtocolName(name);
        this.requestSource = Headers.REQUEST_SOURCE.withProtocolName(name);
        this.requestCatalog = Headers.REQUEST_CATALOG.withProtocolName(name);
        this.requestSchema = Headers.REQUEST_SCHEMA.withProtocolName(name);
        this.requestPath = Headers.REQUEST_PATH.withProtocolName(name);
        this.requestTimeZone = Headers.REQUEST_TIME_ZONE.withProtocolName(name);
        this.requestLanguage = Headers.REQUEST_LANGUAGE.withProtocolName(name);
        this.requestTraceToken = Headers.REQUEST_TRACE_TOKEN.withProtocolName(name);
        this.requestSession = Headers.REQUEST_SESSION.withProtocolName(name);
        this.requestRole = Headers.REQUEST_ROLE.withProtocolName(name);
        this.requestPreparedStatement = Headers.REQUEST_PREPARED_STATEMENT.withProtocolName(name);
        this.requestTransactionId = Headers.REQUEST_TRANSACTION_ID.withProtocolName(name);
        this.requestClientInfo = Headers.REQUEST_CLIENT_INFO.withProtocolName(name);
        this.requestClientTags = Headers.REQUEST_CLIENT_TAGS.withProtocolName(name);
        this.requestClientCapabilities = Headers.REQUEST_CLIENT_CAPABILITIES.withProtocolName(name);
        this.requestResourceEstimate = Headers.REQUEST_RESOURCE_ESTIMATE.withProtocolName(name);
        this.requestExtraCredential = Headers.REQUEST_EXTRA_CREDENTIAL.withProtocolName(name);
        this.requestQueryDataEncoding = Headers.REQUEST_QUERY_DATA_ENCODING.withProtocolName(name);
        this.responseSetCatalog = Headers.RESPONSE_SET_CATALOG.withProtocolName(name);
        this.responseSetSchema = Headers.RESPONSE_SET_SCHEMA.withProtocolName(name);
        this.responseSetPath = Headers.RESPONSE_SET_PATH.withProtocolName(name);
        this.responseSetSession = Headers.RESPONSE_SET_SESSION.withProtocolName(name);
        this.responseClearSession = Headers.RESPONSE_CLEAR_SESSION.withProtocolName(name);
        this.responseSetRole = Headers.RESPONSE_SET_ROLE.withProtocolName(name);
        this.responseQueryDataEncoding = Headers.RESPONSE_QUERY_DATA_ENCODING.withProtocolName(name);
        this.responseAddedPrepare = Headers.RESPONSE_ADDED_PREPARE.withProtocolName(name);
        this.responseDeallocatedPrepare = Headers.RESPONSE_DEALLOCATED_PREPARE.withProtocolName(name);
        this.responseStartedTransactionId = Headers.RESPONSE_STARTED_TRANSACTION_ID.withProtocolName(name);
        this.responseClearTransactionId = Headers.RESPONSE_CLEAR_TRANSACTION_ID.withProtocolName(name);
        this.responseSetAuthorizationUser = Headers.RESPONSE_SET_AUTHORIZATION_USER.withProtocolName(name);
        this.responseResetAuthorizationUser = Headers.RESPONSE_RESET_AUTHORIZATION_USER.withProtocolName(name);
        this.responseOriginalRole = Headers.RESPONSE_SET_ORIGINAL_ROLES.withProtocolName(name);
    }

    public boolean isProtocolHeader(String headerName) {
        for (Headers header : Headers.values()) {
            if (!header.withProtocolName(this.name).equalsIgnoreCase(headerName)) continue;
            return true;
        }
        return false;
    }

    public String getProtocolName() {
        return this.name;
    }

    public String requestUser() {
        return this.requestUser;
    }

    public String requestOriginalUser() {
        return this.requestOriginalUser;
    }

    public String requestOriginalRole() {
        return this.requestOriginalRole;
    }

    public String requestSource() {
        return this.requestSource;
    }

    public String requestCatalog() {
        return this.requestCatalog;
    }

    public String requestSchema() {
        return this.requestSchema;
    }

    public String requestPath() {
        return this.requestPath;
    }

    public String requestTimeZone() {
        return this.requestTimeZone;
    }

    public String requestLanguage() {
        return this.requestLanguage;
    }

    public String requestTraceToken() {
        return this.requestTraceToken;
    }

    public String requestSession() {
        return this.requestSession;
    }

    public String requestRole() {
        return this.requestRole;
    }

    public String requestPreparedStatement() {
        return this.requestPreparedStatement;
    }

    public String requestTransactionId() {
        return this.requestTransactionId;
    }

    public String requestClientInfo() {
        return this.requestClientInfo;
    }

    public String requestClientTags() {
        return this.requestClientTags;
    }

    public String requestClientCapabilities() {
        return this.requestClientCapabilities;
    }

    public String requestResourceEstimate() {
        return this.requestResourceEstimate;
    }

    public String requestExtraCredential() {
        return this.requestExtraCredential;
    }

    public String requestQueryDataEncoding() {
        return this.requestQueryDataEncoding;
    }

    public String responseSetCatalog() {
        return this.responseSetCatalog;
    }

    public String responseSetSchema() {
        return this.responseSetSchema;
    }

    public String responseSetPath() {
        return this.responseSetPath;
    }

    public String responseSetSession() {
        return this.responseSetSession;
    }

    public String responseClearSession() {
        return this.responseClearSession;
    }

    public String responseSetRole() {
        return this.responseSetRole;
    }

    public String responseQueryDataEncoding() {
        return this.responseQueryDataEncoding;
    }

    public String responseAddedPrepare() {
        return this.responseAddedPrepare;
    }

    public String responseDeallocatedPrepare() {
        return this.responseDeallocatedPrepare;
    }

    public String responseStartedTransactionId() {
        return this.responseStartedTransactionId;
    }

    public String responseClearTransactionId() {
        return this.responseClearTransactionId;
    }

    public String responseSetAuthorizationUser() {
        return this.responseSetAuthorizationUser;
    }

    public String responseResetAuthorizationUser() {
        return this.responseResetAuthorizationUser;
    }

    public String responseOriginalRole() {
        return this.responseOriginalRole;
    }

    public static ProtocolHeaders detectProtocol(Optional<String> alternateHeaderName, Set<String> headerNames) throws ProtocolDetectionException {
        Objects.requireNonNull(alternateHeaderName, "alternateHeaderName is null");
        Objects.requireNonNull(headerNames, "headerNames is null");
        if (alternateHeaderName.isPresent() && !alternateHeaderName.get().equalsIgnoreCase("Trino")) {
            String headerPrefix = "x-" + alternateHeaderName.get().toLowerCase(Locale.ENGLISH);
            if (headerNames.stream().anyMatch(header -> header.toLowerCase(Locale.ENGLISH).startsWith(headerPrefix))) {
                if (headerNames.stream().anyMatch(header -> header.toLowerCase(Locale.ENGLISH).startsWith("x-trino-"))) {
                    throw new ProtocolDetectionException("Both Trino and " + alternateHeaderName.get() + " headers detected");
                }
                return ProtocolHeaders.createProtocolHeaders(alternateHeaderName.get());
            }
        }
        return TRINO_HEADERS;
    }

    static enum Headers {
        REQUEST_USER("User"),
        REQUEST_ORIGINAL_USER("Original-User"),
        REQUEST_ORIGINAL_ROLES("Original-Roles"),
        REQUEST_SOURCE("Source"),
        REQUEST_CATALOG("Catalog"),
        REQUEST_SCHEMA("Schema"),
        REQUEST_PATH("Path"),
        REQUEST_TIME_ZONE("Time-Zone"),
        REQUEST_LANGUAGE("Language"),
        REQUEST_TRACE_TOKEN("Trace-Token"),
        REQUEST_SESSION("Session"),
        REQUEST_ROLE("Role"),
        REQUEST_PREPARED_STATEMENT("Prepared-Statement"),
        REQUEST_TRANSACTION_ID("Transaction-Id"),
        REQUEST_CLIENT_INFO("Client-Info"),
        REQUEST_CLIENT_TAGS("Client-Tags"),
        REQUEST_CLIENT_CAPABILITIES("Client-Capabilities"),
        REQUEST_RESOURCE_ESTIMATE("Resource-Estimate"),
        REQUEST_EXTRA_CREDENTIAL("Extra-Credential"),
        REQUEST_QUERY_DATA_ENCODING("Query-Data-Encoding"),
        RESPONSE_SET_CATALOG("Set-Catalog"),
        RESPONSE_SET_SCHEMA("Set-Schema"),
        RESPONSE_SET_PATH("Set-Path"),
        RESPONSE_SET_SESSION("Set-Session"),
        RESPONSE_CLEAR_SESSION("Clear-Session"),
        RESPONSE_SET_ROLE("Set-Role"),
        RESPONSE_SET_ORIGINAL_ROLES("Set-Original-Roles"),
        RESPONSE_QUERY_DATA_ENCODING("Query-Data-Encoding"),
        RESPONSE_ADDED_PREPARE("Added-Prepare"),
        RESPONSE_DEALLOCATED_PREPARE("Deallocated-Prepare"),
        RESPONSE_STARTED_TRANSACTION_ID("Started-Transaction-Id"),
        RESPONSE_CLEAR_TRANSACTION_ID("Clear-Transaction-Id"),
        RESPONSE_SET_AUTHORIZATION_USER("Set-Authorization-User"),
        RESPONSE_RESET_AUTHORIZATION_USER("Reset-Authorization-User");

        private final String headerName;

        private Headers(String headerName) {
            this.headerName = Objects.requireNonNull(headerName, "headerName is null");
        }

        public String withProtocolName(String protocolName) {
            return "X-" + protocolName + "-" + this.headerName;
        }
    }
}

