/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import io.trino.jdbc.$internal.guava.annotations.VisibleForTesting;
import io.trino.jdbc.$internal.guava.base.Joiner;
import io.trino.jdbc.$internal.guava.base.MoreObjects;
import io.trino.jdbc.$internal.guava.base.StandardSystemProperty;
import io.trino.jdbc.$internal.guava.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;

public class UserAgentBuilder {
    private static final Joiner.MapJoiner MAP_JOINER = Joiner.on(" ").withKeyValueSeparator("=");
    private static final String LANGUAGE = "lang/java";
    private static final String OS_NAME = "os";
    private static final String OS_VERSION = "os/version";
    private static final String ARCH = "arch";
    private static final String VENDOR = "java/vendor";
    private static final String VM_NAME = "java/vm";
    private static final String LOCALE = "locale";

    private UserAgentBuilder() {
    }

    public static String createUserAgent(String product) {
        return UserAgentBuilder.createUserAgent(product, UserAgentBuilder.getProductVersion());
    }

    public static String createUserAgent(String product, String version) {
        return UserAgentBuilder.createUserAgent(product, version, ImmutableMap.of());
    }

    public static String createUserAgent(String product, Map<String, String> metadata) {
        return UserAgentBuilder.createUserAgent(product, UserAgentBuilder.getProductVersion(), metadata);
    }

    public static String createUserAgent(String product, String version, Map<String, String> metadata) {
        ImmutableMap.Builder<String, String> sourceBuilder = ImmutableMap.builder();
        sourceBuilder.put(OS_NAME, UserAgentBuilder.sanitize(StandardSystemProperty.OS_NAME.value()));
        sourceBuilder.put(OS_VERSION, UserAgentBuilder.sanitize(StandardSystemProperty.OS_VERSION.value()));
        sourceBuilder.put(ARCH, UserAgentBuilder.sanitize(StandardSystemProperty.OS_ARCH.value()));
        sourceBuilder.put(LANGUAGE, StandardSystemProperty.JAVA_VM_VERSION.value());
        sourceBuilder.put(VM_NAME, UserAgentBuilder.sanitize(StandardSystemProperty.JAVA_VM_NAME.value()));
        sourceBuilder.put(VENDOR, UserAgentBuilder.sanitize(StandardSystemProperty.JAVA_VENDOR.value()));
        sourceBuilder.put(LOCALE, Locale.getDefault().toLanguageTag());
        sourceBuilder.putAll(metadata);
        return String.format("%s/%s", product, version) + " " + MAP_JOINER.join(sourceBuilder.buildOrThrow());
    }

    @VisibleForTesting
    static String sanitize(String value) {
        return value.replaceAll("[^a-zA-Z0-9_.-]+", "_");
    }

    private static String getProductVersion() {
        String version = UserAgentBuilder.class.getPackage().getImplementationVersion();
        return MoreObjects.firstNonNull(version, "unknown");
    }
}

